@echo off
echo CS2650 Ex4 Example - Using Petri Net Component
echo Callen Shaw (cts8)
echo -
echo This script will guide you through a test of the Petri Net Component
echo The Net will replace the Time Controller
echo -
echo Please just follow the prompts in this script for a successful test.
pause
echo The script will now run SIS Server and PrjRemote...
pause
start "SIS Server" java -cp ./SISv2_1/System/SISServer/ SISServer
start "prjRemote" java -jar ./SISv2_1/prjRemote.jar
echo Now, hit Connect on prjRemote.
pause
echo -
echo Hit Load, and load the file list_initXML.txt. Then hit Send All.
pause
echo Good. All component definitions should be in the SIS Server now.
echo -
echo -
echo Now I'm going to run the Ex4 components, including KB, Verifier, and Eliminator
pause
start runKB-Veri-Elim.bat
echo Great! Next we need to initialize the KB with the file list_kbdata.txt.  
echo Load this file in PrjRemote and then hit Send
pause
echo OK, almost done.  I'm going to spawn components by running my Enumerator.
pause
cls
start /D"./SISv2_1/cts/" java CtsEnumComp
cls
echo This is the part that really matters now.
echo -
echo I'm going to run the Petri Net.  It initially blocks, waiting for a token on
echo the Place in the top left (id=p_Loop_Control).  Once you put one there, it
echo will send 5 predetermined BS reading messages to the SIS server.  You should
echo easily see which transitions are doing this (the zig-zag pattern at the 
echo bottom).  You have to put a token at p_Loop_Control for every 5 messages (one
echo loop) the Petri Net sends.
echo -
echo -
echo Additionally, in the top middle is the Place (id=p_Signal_Elimination) that
echo signals the Eliminator component to make its elimination decisions. You could
echo view this as the "Panic button" from the old Ex-4 Time Controller. This works
echo because when the Transition (id=t_Send_Elim_Msg) is fired, it sends the
echo eliminate message (MsgID=310).
echo -
echo -
echo When you understand all of the above, hit enter to launch the Petri Net Comp!
pause
java -cp ./bin NetSim tina-tc-net.pnml